
-- beachte auch TSystem.views__all__create()
CREATE OR REPLACE VIEW textx AS
        SELECT prodat_languages.lang_text(t_nr) AS t_feld,
               *
          FROM text0;


--Artikelviews und Artikel mehrsprachig
CREATE OR REPLACE FUNCTION tartikel.art_multilang_updatelang(aknr VARCHAR, langcode VARCHAR, txt VARCHAR) RETURNS VOID AS $$
    BEGIN
        IF langcode=prodat_languages.curr_lang() THEN--aktuelle Sprache, überträgt automatisch in Subtabelle
               UPDATE art SET ak_bez = txt WHERE ak_nr = aknr;
               RETURN;
        END IF;
        --
        IF txt IS NULL THEN
               DELETE FROM artblang WHERE akbl_ak_nr = aknr AND akbl_spr_key = langcode;
               RETURN;
        END IF;
        --
        UPDATE artblang SET akbl_txt = txt WHERE akbl_ak_nr = aknr AND akbl_spr_key = langcode;
        --
        IF NOT found THEN
               INSERT INTO artblang(akbl_ak_nr, akbl_spr_key, akbl_txt) VALUES (aknr, langcode, txt);
        END IF;
        --
        RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TSystem.views__artikel__drop() RETURNS VOID
    AS $$
    BEGIN
        DROP VIEW IF EXISTS art_lang;
        DROP VIEW IF EXISTS art_small;
        DROP VIEW IF EXISTS tartikel.art_multilang CASCADE; -- da hängt ein rule dran
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TSystem.views__artikel__recreate() RETURNS VOID AS $$
 BEGIN

  CREATE OR REPLACE VIEW art_lang AS SELECT * FROM art;

  CREATE OR REPLACE VIEW art_small AS SELECT dbrid, ak_ac, ak_nr, ak_bez, ak_znr, ak_mat, ak_dim, ak_standard_mgc, ak_verfueg, ak_tot, ak_bes, ak_res FROM art;

  --folgendes muß in DO weil sonst das Erstellunggscript knallt: DEVART parst mit den Klammern hier etwas falsch!
  EXECUTE '
    CREATE OR REPLACE VIEW tartikel.art_multilang AS
        SELECT art.*, ac_i,
                (SELECT akbl_txt FROM artblang WHERE akbl_ak_nr=ak_nr AND akbl_spr_key=''D'') AS ak_bez_de,
                (SELECT akbl_txt FROM artblang WHERE akbl_ak_nr=ak_nr AND akbl_spr_key=''EN'') AS ak_bez_en
        FROM art JOIN artcod ON ak_ac=ac_n; --JOIN wegen Suche nach IC

    CREATE OR REPLACE RULE art_update_lang AS ON UPDATE TO tartikel.art_multilang DO INSTEAD
        (SELECT tartikel.art_multilang_updatelang(new.ak_nr, ''D'', new.ak_bez_de);
         SELECT tartikel.art_multilang_updatelang(new.ak_nr, ''EN'', new.ak_bez_en);
        );';
 END $$ LANGUAGE plpgsql;

SELECT TSystem.views__artikel__recreate();
--

---------------------------------------- BDEP- /Personal-VIEWS ----------------------------------------

-- Views zur Berechnung der auf Monat summierten Abwesenheit
  -- Erzeugung auch per FUNCTION TSystem.views__all__create. Hier initial für vorhandene Verwendungen?
/*
CREATE OR REPLACE VIEW bdepabsum AS
        SELECT mpl_formonth, 
               mpl_date, 
               mpl_minr, 
               sum(bdab_stu) AS bdab_stu, 
               ab_id, 
               cast(ab_txt AS text), 
               bdab_buch,
               string_agg(bdab_bem, ',')::varchar(100) AS bdab_bem_agg
          FROM mitpln 
          JOIN bdepab ON (mitpln.mpl_minr = bdepab.bdab_minr) AND (mitpln.mpl_date BETWEEN bdepab.bdab_anf AND bdepab.bdab_end)
          LEFT JOIN bdeabgruende ON (bdab_aus_id = bdeabgruende.ab_id)
         WHERE bdab_stu IS NOT NULL --AND mpl_feiertag IS NULL
         GROUP BY ab_id, ab_txt, mpl_minr, mpl_date, bdab_buch, mpl_formonth
 UNION
        SELECT mpl_formonth, 
               mpl_date, 
               mpl_minr, 
               CASE WHEN ab_id = 100 THEN CAST(tpl_abw AS NUMERIC)/2 ELSE tpl_abw END AS bdab_stu, 
               ab_id, 
               CAST(ab_txt AS text), 
               bdab_buch,
               bdab_bem AS bdab_bem_agg
          FROM mitpln JOIN bdepab ON (mitpln.mpl_minr = bdepab.bdab_minr) AND (mitpln.mpl_date BETWEEN bdepab.bdab_anf AND bdepab.bdab_end)
          LEFT JOIN tplan ON (mpl_tpl_name = tplan.tpl_name)
          LEFT JOIN bdeabgruende ON (bdab_aus_id = bdeabgruende.ab_id)
         WHERE bdab_stu IS NULL AND mpl_feiertag IS NULL;

CREATE OR REPLACE VIEW urlaubsum AS
        SELECT mpl_formonth, 
               mpl_date, 
               mpl_minr, 
               sum(bdab_stu) AS bdab_stu, 
               ab_id, 
               ab_txt
          FROM mitpln 
          JOIN bdepab ON (mitpln.mpl_minr = bdepab.bdab_minr) AND (mitpln.mpl_date BETWEEN bdepab.bdab_anf AND bdepab.bdab_end)
          LEFT JOIN bdeabgruende ON (bdab_aus_id = bdeabgruende.ab_id)
         WHERE bdab_stu IS NOT NULL AND NOT bdab_buch AND ab_id=1 AND mpl_feiertag IS NULL
         GROUP BY ab_id, ab_txt, mpl_minr, mpl_date, mpl_formonth
 UNION
        SELECT mpl_formonth, 
               mpl_date, 
               mpl_minr, 
               tpl_abw AS bdab_stu, 
               ab_id, 
               ab_txt
          FROM mitpln 
          JOIN bdepab ON (mitpln.mpl_minr = bdepab.bdab_minr) AND (mitpln.mpl_date BETWEEN bdepab.bdab_anf AND bdepab.bdab_end)
          JOIN tplan ON (mpl_tpl_name = tplan.tpl_name)
          LEFT JOIN bdeabgruende ON (bdab_aus_id = bdeabgruende.ab_id)
         WHERE bdab_stu IS NULL AND NOT bdab_buch AND ab_id=1 AND mpl_feiertag IS NULL;
--
*/

--
CREATE OR REPLACE FUNCTION TSystem.view__tpersonal__llv__stundauszahl__karenzantrag__recreate() RETURNS void AS $$
  BEGIN
    -- #13822 Analog Druckliste Überstundennachweis aufgebaut
      -- 1 Zeile pro Tag, statt pro Stempelung, daher first und last
      -- individueller Werktag wird simuliert über Tpersonal.bdep__individwt__get_date__by_bd_anf_minr
        -- mit Option _use_individwt_valid_from_date => false, also individueller Werktag immer gültig und nicht abhängig vom Gültigkeitsdatum
      -- RULE beachten
    CREATE OR REPLACE VIEW tpersonal.llv__stundauszahl__karenzantrag AS
      SELECT
        mpl_date,
        mpl_minr,
        mpl_tpl_name,
        mpl_saldo - mpl_min + mpl_absaldo AS mpl_gutschrift,

        -- Tagesanfang
        bdep_first.bd_id AS bdep_first__bd_id,
        bdep_first.bd_karenz_antrag,
        --"Karenz (Ko) genehmigt"
        NOT bdep_first.bd_karenz AS bd_karenz_antrag_cimgreen,
        -- bdep_first.bd_anf, bdep_first.bd_anf_rund,

        -- auf Tagesplanrundung gerechnet OHNE Karenzrundung
        bdep_first_rund._anf_time_rounded AS bdep_first_bd_anf_tplrund,

        -- So viel Zeit gewinnt der Mitarbeiter durch seinen Antrag
        CASE
            WHEN
                    bdep_first.bd_karenz
                AND mpl_tpl_name IS NOT NULL
                AND (bdep_first.bd_anf::time BETWEEN karenz_first.kr_anf::time AND karenz_first.kr_newtime::time)
            THEN
                timediff( bdep_first_rund._anf_time_rounded, bdep_first.bd_anf_rund )
            ELSE null
        END AS tdiff_first,

        --Tagesende
        bdep_last.bd_id AS bdep_last__bd_id,
        bdep_last.bd_karenz_antrag_end,
        -- "Karenz (Ge) genehmigt"
        NOT bdep_last.bd_karenz_end AS bd_karenz_antrag_end_cimgreen,
        -- bdep_last.bd_end, bdep_last.bd_end_rund,

        -- auf Tagesplanrundung gerechnet OHNE Karenzrundung
        bdep_last_rund._end_time_rounded AS bdep_last_bd_end_tplrund,

        CASE
            WHEN
                    bdep_last.bd_karenz_end
                AND mpl_tpl_name IS NOT NULL
                AND (bdep_last.bd_end::time BETWEEN karenz_last.kr_newtime::time AND karenz_last.kr_end)
            THEN
                timediff( bdep_last.bd_end_rund, bdep_last_rund._end_time_rounded )
            ELSE null
        END AS tdiff_last

        -- DEBUG Spalten
        -- , karenz_first.kr_anf, karenz_first.kr_newtime
        -- , karenz_last.kr_end, karenz_last.kr_newtime
      FROM mitpln
        -- Simulation von bd_individwt_mpl_date, um ersten und letzten BDEP-Satz anhand des individ. Werktages ermitteln zu können.
        -- Dazu wird der zugehörige individ. Werktag der BDEP-Sätze um mpl_date herum (+-1) ermittelt.
        -- erster BDEP-Satz des individ. Werktags
        LEFT JOIN bdep AS bdep_first
            ON  bdep_first.bd_id =
                (
                  SELECT bd_id
                  FROM bdep
                  -- Per Option (false): individueller Werktag immer gültig und nicht abhängig vom Gültigkeitsdatum
                  WHERE Tpersonal.bdep__individwt__get_date__by_bd_anf_minr( bd_anf, bd_minr, false )::date = mpl_date
                    AND bd_minr = mpl_minr
                    AND timestamp_to_date( bd_anf ) BETWEEN mpl_date - 1 AND mpl_date + 1
                  ORDER BY bd_anf ASC
                  LIMIT 1
                )
        -- letzter BDEP-Satz des individ. Werktags
        LEFT JOIN bdep AS bdep_last
            ON  bdep_last.bd_id =
                (
                  SELECT bd_id
                  FROM bdep
                  -- Per Option (false): individueller Werktag immer gültig und nicht abhängig vom Gültigkeitsdatum
                  WHERE Tpersonal.bdep__individwt__get_date__by_bd_anf_minr( bd_anf, bd_minr, false )::date = mpl_date
                    AND bd_minr = mpl_minr
                    AND timestamp_to_date( bd_anf ) BETWEEN mpl_date - 1 AND mpl_date + 1
                  ORDER BY bd_end DESC
                  LIMIT 1
                )

        LEFT JOIN karenz AS karenz_first
            ON  karenz_first.kr_tpl_name = mpl_tpl_name
            AND karenz_first.kr_anf = ( SELECT kr_anf FROM karenz WHERE kr_tpl_name = mpl_tpl_name ORDER BY kr_anf ASC   LIMIT 1 )
        LEFT JOIN karenz AS karenz_last
            ON  karenz_last.kr_tpl_name = mpl_tpl_name
            AND karenz_last.kr_anf =  ( SELECT kr_anf FROM karenz WHERE kr_tpl_name = mpl_tpl_name ORDER BY kr_anf DESC  LIMIT 1 )

        -- bdep-anf und -end auf Tagesplanrundung gerechnet OHNE Karenzrundung
        LEFT JOIN LATERAL TPersonal.bdep__anf_end__round__by__tplan( bdep_first.bd_anf, bdep_first.bd_end,  mpl_tpl_name ) AS bdep_first_rund ON true
        LEFT JOIN LATERAL TPersonal.bdep__anf_end__round__by__tplan( bdep_last.bd_anf,  bdep_last.bd_end,   mpl_tpl_name ) AS bdep_last_rund  ON true
    ;

    -- Rule für Aktualisierung der Ausgabe
      -- DROP VIEW kaskadiert automatisch
    EXECUTE $createrule$
        CREATE OR REPLACE RULE tpersonal__llv__stundauszahl__karenzantrag__update AS  -- reiner Name: keine Angabe vom Schema möglich
          ON UPDATE
          TO tpersonal.llv__stundauszahl__karenzantrag
          DO INSTEAD (
              -- ersten Datensatz aktualisieren
              UPDATE bdep SET
                bd_karenz_antrag = new.bd_karenz_antrag
              WHERE bd_id = new.bdep_first__bd_id
                -- Sicherung für Speichern nur im validen Zeitraum
                AND (tpersonal.llv__stundauszahl__defDate__get( new.mpl_minr )).defDate = last_day( new.mpl_date )
              ;

              -- letzten Datensatz aktualisieren
              UPDATE bdep SET
                bd_karenz_antrag_end = new.bd_karenz_antrag_end
              WHERE bd_id = new.bdep_last__bd_id
                AND (tpersonal.llv__stundauszahl__defDate__get( new.mpl_minr )).defDate = last_day( new.mpl_date )
              ;
          )
        ;
    $createrule$
    ;

  END $$ LANGUAGE plpgsql;
--

---------------------------------------- BDEP- /Personal-VIEWS Ende -----------------------------------


/*******************************************************************************************
VIEWS AUF DIE BELEGSTRUKTUREN - REDUZIEREN FELDER ANZAHL UND SCHRÄNKEN AUF BELEGTYP EIN.
*******************************************************************************************/


--siehe funktion


/*******************************************************************************************
Die sind nur da, das man das nicht alles wieder zusammenschreiben muss, wenn man mal einen Spaltentyp oder sowas ändern will. Das geht nämlich nicht, wenn die Spalte in nem View verwendet wird.
*******************************************************************************************/

--
CREATE OR REPLACE FUNCTION TSystem.views__beleg__drop() RETURNS VOID AS $$
  BEGIN
    DROP VIEW IF EXISTS eingrech CASCADE;
    DROP VIEW IF EXISTS eingrech_pos CASCADE;
    DROP VIEW IF EXISTS lieferschein CASCADE;
    DROP VIEW IF EXISTS lieferschein_pos CASCADE;
    --
    DROP VIEW IF EXISTS z_99_deprecated.eingrechdokument CASCADE;
    --
    DROP VIEW IF EXISTS z_99_deprecated.eingrech_pos CASCADE;
    --
    DROP VIEW IF EXISTS z_99_deprecated.belegabzu CASCADE;
    DROP VIEW IF EXISTS z_99_deprecated.belegposabzu CASCADE;
    DROP VIEW IF EXISTS z_99_deprecated.belegpos CASCADE;
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.views__beleg__recreate() RETURNS VOID AS $$
 BEGIN

    -- View auf Eingrechdokument, damit in F2 und Listen separiert von anderen Belegen
    CREATE OR REPLACE VIEW eingrech AS SELECT * FROM eingrechdokument WHERE beld_belegtyp = 'ERG';


    -- View auf Belegpos mit Einschraenkung Belegtyp, damit EingRech in F2 und Listen separiert von anderen Belegen
    CREATE OR REPLACE VIEW eingrech_pos AS SELECT * FROM belegpos WHERE belp_belegtyp = 'ERG';


    -- View auf Eingrechdokument, damit in F2 und Listen separiert von anderen Belegen
    CREATE OR REPLACE VIEW lieferschein AS
     SELECT
        beld_id,
        beld_belegtyp,
        beld_belegart,
        beld_dokunr,
        beld_definitiv,
        beld_verbucht,
        beld_freigabe,
        beld_print,
        beld_titel,
        beld_kopftext,
        beld_kopftext_rtf,
        beld_fusstext,
        beld_fusstext_rtf,
        beld_apkrzl,
        beld_ap,
        beld_apint,
        beld_versandart,
        beld_versandartbem,
        beld_versandort,
        beld_erstelldatum,
        -- beld_abschlussdatum,
        beld_krzbesteller,
        beld_krzlieferung,
        beld_krzrechnung,
        beld_refbeleg,
        beld_gewicht,
        insert_date,
        insert_by,
        modified_by,
        modified_date,
        dbrid
       FROM
        belegdokument
      WHERE
       belegdokument.beld_belegtyp = 'LFS';

    -- View auf Belegpos mit Einschraenkung Belegtyp, damit EingRech in F2 und Listen separiert von anderen Belegen
     -- ACHTUNG: Den View nicht um Felder erweitern, die nicht in der Basistabelle sind oder Funktionen einbauen. Der muss Updatable bleiben.
     -- SIEHE AUCH: Y_TWawi.Views.Lieferschein.sql
    CREATE OR REPLACE VIEW lieferschein_pos AS
     SELECT
        belp_id,
        belp_belegtyp,
        belp_dokument_id,
        belp_beleg_id, -- ALTER MIST!
        belp_pos,
        belp_vorgaenger,
        belp_ag_id,
        -- belp_w_wen,
        belp_l_nr,
        belp_ab_ix,
        belp_a2_id,
        belp_q_nr,
        belp_krzbesteller,
        belp_krzrechnung,
        belp_krzlieferung,
        belp_aknr,
        belp_akbez,
        belp_referenzaknr,
        belp_menge,
        belp_menge_gme,
        belp_menge_done,
        belp_menge_done_gme,
        belp_mce,
        belp_termin,
        belp_erstelldatum,
        belp_projektnummer,
        belp_txt,
        belp_txt_rtf,
        belp_dokutxt,
        belp_dokutxt_rtf,
        belp_referenz,
        belp_erledigt,
        belp_storniert,
        -- belp_versandart,
        -- belp_versandartbem,
        belp_gewicht,
        belp_lp_id,
        belp_bstat,
        belp_bstat1,
        belp_bstat2,
        insert_date,
        insert_by,
        modified_by,
        modified_date,
        dbrid,
        -- Kompatibilität alte / neue Belegstruktur. JOIN Fields für Delphi-SQL da mit ERG vermischt in einer Klasse
        NULL::VARCHAR AS belp_kostenstelle,
        NULL::VARCHAR AS belp_konto,
        NULL::INTEGER AS belp_steucode
       FROM
        belegpos
      WHERE
       belegpos.belp_belegtyp = 'LFS';

 END $$ LANGUAGE plpgsql;
--
SELECT TSystem.views__beleg__recreate();


--View für Serviceanfragen wegen Verlinkungen

CREATE OR REPLACE VIEW anfrageservice AS SELECT * FROM kundanfrage WHERE kanf_isService;

CREATE OR REPLACE VIEW qabService AS SELECT * FROM qab WHERE q_isService;


CREATE OR REPLACE FUNCTION TSystem.view__cycles_info__recreate() RETURNS VOID AS $$
    BEGIN
        -- Auswertung für TFormCycles
        CREATE OR REPLACE VIEW cycles_info AS
          SELECT
            cycles.*,
            NOT cycle__isused(cyc_src_key, cyc_src_dbrid) AS deleted,
            CASE
              WHEN cyc_src_key = 'vertrag_pos' THEN 'vtr_nr'
              WHEN cyc_src_key = 'vertrag' THEN 'vtr_nr'
              WHEN cyc_src_key = 'abk' THEN 'ab_ix'
              WHEN cyc_src_key = 'anl' THEN 'an_nr'
              ELSE NULL
            END AS key_field,
            CASE
              WHEN cyc_src_key = 'vertrag_pos' THEN vtp_vtr_nr
              WHEN cyc_src_key = 'vertrag' THEN vtr_nr
              WHEN cyc_src_key = 'abk' THEN CAST(ab_ix AS VARCHAR)
              WHEN cyc_src_key = 'anl' THEN an_nr
              ELSE NULL
            END AS key_value,
            CASE
              WHEN cyc_src_key = 'vertrag_pos' THEN 'Vertrag=' || COALESCE(vtp_vtr_nr, '') || '  Position=' || COALESCE(CAST(vtp_pos AS VARCHAR), '') || '  ID=' || COALESCE(CAST(vtp_id AS VARCHAR), '')
              WHEN cyc_src_key = 'vertrag' THEN 'Vertrag=' || COALESCE(vtr_nr, '') || 'Projekt=' || COALESCE(vtr_an_nr, '') || '  Kunde=' || COALESCE(vtr_krz, '') || '  Artikel=' || COALESCE(vtr_art, '')
              WHEN cyc_src_key = 'abk' THEN 'ABK-Index=' || COALESCE(CAST(ab_ix AS VARCHAR), '') || '  Arbeitspaket=' || COALESCE(ab_ap_nr, '') || '  Projekt=' || COALESCE(ab_an_nr, '') || '  Tabelle=' || COALESCE(ab_tablename, '')
              WHEN cyc_src_key = 'anl' THEN 'Projekt=' || an_nr || '  Projektbezeichnung=' || COALESCE(an_bez, '') || '  Artikel=' || COALESCE(an_ak_nr, '')
              ELSE NULL
            END AS key_info
          FROM cycles
          LEFT JOIN vertrag_pos ON cyc_src_key = 'vertrag_pos' AND vertrag_pos.dbrid = cyc_src_dbrid
          LEFT JOIN vertrag ON cyc_src_key = 'vertrag' AND vertrag.dbrid = cyc_src_dbrid
          LEFT JOIN abk ON cyc_src_key = 'abk' AND abk.dbrid = cyc_src_dbrid
          LEFT JOIN anl ON cyc_src_key = 'anl' AND anl.dbrid = cyc_src_dbrid;
        --
    END $$ LANGUAGE plpgsql;
--
SELECT TSystem.view__cycles_info__recreate();
--
